local iIndex = Var("GameCommand"):GetIndex();
local sName = Var("GameCommand"):GetName();

local coverFile;
if File.Read("Themes/moonlight/Graphics/_gameplay covers/setting.cfg") then
	coverFile = tostring( File.Read("Themes/moonlight/Graphics/_gameplay covers/setting.cfg") );
else
	coverFile = "default";
end;

local t = Def.ActorFrame{};

if sName == "Filter" then
	t[#t+1] = Def.ActorFrame{
		Def.Quad{
			InitCommand=cmd(zoomto,SCREEN_WIDTH*0.4,SCREEN_HEIGHT;diffuse,color("0,0,0,0.5"););
			GainFocusCommand=cmd(accelerate,0.15;diffuse,color("0.25,0.25,0.25,0.5"));
			LoseFocusCommand=cmd(stoptweening;decelerate,0.15;diffuse,color("0,0,0,0.5"));
		};
	};
elseif sName == "Cover" then
	t[#t+1] = Def.ActorFrame{
		LoadActor( THEME:GetPathG("_gameplay","covers/".. coverFile .."/4panel") )..{
			GainFocusCommand=cmd(accelerate,0.15;diffuse,color("1,1,1,1"));
			LoseFocusCommand=cmd(stoptweening;decelerate,0.15;diffuse,color("0.6,0.6,0.6,0.9"));
		};
	};
end;

t[#t+1] = Def.ActorFrame{
	Name="Item"..iIndex;

	AutoText("frutiger")..{
		Name="Name"..iIndex;
		Text=THEME:GetString(Var 'LoadingScreen',sName);
		InitCommand=cmd(shadowlength,1;diffuse,color("#FFFFFF");NoStroke);
		OnCommand=cmd(y,(SCREEN_CENTER_Y*0.8)-48);
		GainFocusCommand=cmd(accelerate,0.15;zoom,1;diffuse,color("1,1,1,1"));
		LoseFocusCommand=cmd(stoptweening;decelerate,0.15;zoom,0.8;diffuse,color("0.6,0.6,0.6,0.9"));
	};

	AutoText("frutiger")..{
		Name="Descrption"..iIndex;
		Text=THEME:GetString(Var 'LoadingScreen',sName.."Description");
		InitCommand=cmd(shadowlength,1;zoom,0.6;diffuse,color("#FFFFFF");NoStroke);
		OnCommand=cmd(y,(SCREEN_CENTER_Y*0.8)-18);
	};
};

return t;